#include "snow.inc"
#include "temp.inc"
// ---add include files---
#include "colors.inc"
#include "new_structure.inc"
#include "textures.inc"


// -----------------------
// The default tile scale in this pov-ray file (not for pak file)
#local paksize=128;


// ---camera setting---
camera {
	orthographic
	location <100,81.64965809277,100>*number_hight*paksize/128*3
	look_at <0,0.5,0>*paksize/128
	right<1,0,-1> *paksize*number_width*2
	up<1,0,1>  *paksize*number_hight/2*3
	}


// ---light setting---
light_source {
	<0,173,100>
	color rgb 1
	parallel
	point_at<0,0,0>
}
// If winter==1, set a light to make the snow cover.
#declare winter = 1;
#declare diagonal = 1;
#if(winter)
	light_source{winter_light}
#end


// ----------------------------------
//
// the name of the object with all objects merged must be "obj"
//
// ---make objects below this line---
#declare height_base = 24;
#declare height_water = 14;
#declare rad = 8;
#declare waterpipe_texture=texture{pigment{color Gray10}
finish{diffuse 0.3
brilliance 2}
}
#declare pipe_obj =
object{
	merge{
		object{
			intersection{
			object{
				torus {
					2,1
				}
				rotate<0,0,90>
				translate<paksize/4,height_base,rad*2>
			}
			object{box{<0,height_base,rad*2>,<paksize/2,height_base+10,paksize/2>}}
			}
		}
		object{
			intersection{
			object{
				torus {
					2,1
				}
				rotate<0,0,90>
				translate<paksize/4,height_base,rad*2+4>
			}
			object{box{<0,height_base,rad*2+4>,<paksize/2,0,0>}}
			}
		}
		object{cylinder{<paksize/4,height_base-2,rad*2+4>,<paksize/4,height_base-2,paksize/4-2>,1}texture{waterpipe_texture}}
		object{
			intersection{
			object{
				torus {
					2,1
				}
				rotate<0,0,90>
				translate<paksize/4,height_base-4,paksize/4-2>
			}
			object{box{<0,height_base-4,paksize/4-2>,<paksize/2,paksize/2,paksize/2>}}
			}
		}
	}
	texture{waterpipe_texture}
}
#declare tank_texture=
texture{
	pigment{
		agate
		agate_turb 0.3
		color_map {
			[0.8 color IndianRed]
			[0.9 color DarkGreen]
		}
	}
	finish{diffuse 0.3
	brilliance 2}
}
#declare base_texture=
texture{
	pigment{
		#if(winter)
		color Gray90
		#else
		color Gray30
		#end
	}
	finish{crand 0.3}
}
#declare obj=
merge{
	object{
		cylinder{<paksize/4,0,rad>,<paksize/4,height_base-2,rad>,rad}
		texture{
			pigment{
				brick
				//  color Gray color rgb<0.8,0.3,0.1>
				// rotate <90,0,0>
				scale 1
				mortar 0.4
				translate<.5,0,0>
			}
		}
	}
	object{
		cylinder{<paksize/4,height_base-2,rad>,<paksize/4,height_base,rad>,rad+1}
		texture{
			base_texture
		}
	}
	object{
		cylinder{<paksize/4,height_base,rad>,<paksize/4,height_water+height_base,rad>,rad}
		texture{
			pigment{
				color Gray50
			}
			normal{
				quilted
			}
			// tank_texture
		}
	}
	object{
		cone{<0,0,0>,rad+2,<0,4,0>,0}
		texture{
			pigment{
				color Firebrick
			}
			normal {
				radial
     			frequency 4
				rotate<90,0,0>
				scale 0.03
			}
			finish{crand 0.2}
		}
		translate<paksize/4,height_water+height_base,rad>
	}
	object{
		intersection{
			object{torus{2,1}rotate<90,0,0>translate<paksize/4+rad,height_water+height_base-2,rad>}
			object{box{<0,height_water+height_base-2,0>,<paksize/2,paksize/2,paksize/2>}}
		}
		texture{waterpipe_texture}
	}
	object{
		cylinder{<paksize/4+rad+2,0,rad>,<paksize/4+rad+2,height_water+height_base-2,rad>,1}
		texture{waterpipe_texture}
	}
	object{
		intersection{
			object{torus{2,1}rotate<90,0,0>translate<paksize/4-rad,height_base-1,rad>}
			object{box{<0,height_water-1,0>,<paksize/2,paksize/2,paksize/2>}}
		}
		texture{waterpipe_texture}
	}
	object{
		cylinder{<paksize/4-rad-2,0,rad>,<paksize/4-rad-2,height_base-1,rad>,1}
		texture{waterpipe_texture}
	}
	object{pipe_obj}
}
#declare obj2=
merge{
	object{merge{
		object{naname(<paksize/4-rad+.5,height_base-2,0+.5>,<paksize/4-rad+.5,0,rad*2-.5>,1,1)}
		object{naname(<paksize/4-rad+.5,height_base-2,rad*2-.5>,<paksize/4-rad+.5,0,0+.5>,1,1)}
		object{naname(<paksize/4+rad-.5,height_base-2,0+.5>,<paksize/4+rad-.5,0,rad*2-.5>,1,1)}
		object{naname(<paksize/4+rad-.5,height_base-2,rad*2-.5>,<paksize/4+rad-.5,0,0+.5>,1,1)}
		object{naname(<paksize/4-rad+.5,height_base-2,0+.5>,<paksize/4+rad-.5,0,0+.5>,1,1)}
		object{naname(<paksize/4+rad-.5,height_base-2,0+.5>,<paksize/4-rad+.5,0,0+.5>,1,1)}
		object{naname(<paksize/4-rad+.5,height_base-2,rad*2-.5>,<paksize/4+rad-.5,0,rad*2-.5>,1,1)}
		object{naname(<paksize/4+rad-.5,height_base-2,rad*2-.5>,<paksize/4-rad+.5,0,rad*2-.5>,1,1)}
		object{naname(<paksize/4-rad+.5,height_base-2,0+.5>,<paksize/4-rad+.5,0,0+.5>,1,1)}
		object{naname(<paksize/4+rad-.5,height_base-2,0+.5>,<paksize/4+rad-.5,0,0+.5>,1,1)}
		object{naname(<paksize/4-rad+.5,height_base-2,rad*2-.5>,<paksize/4-rad+.5,0,rad*2-.5>,1,1)}
		object{naname(<paksize/4+rad-.5,height_base-2,rad*2-.5>,<paksize/4+rad-.5,0,rad*2-.5>,1,1)}
		object{box{<paksize/4-rad,height_base-2,0>,<paksize/4+rad,height_base,rad*2>}}
		}
		texture{
			base_texture
		}
	}
	object{
		cylinder{<paksize/4,height_base,rad>,<paksize/4,height_water+height_base,rad>,rad}
		texture{
			tank_texture
		}
	}
	object{
		cone{<0,0,0>,rad+2,<0,4,0>,0}
		texture{
			pigment{
				color Firebrick
			}
			normal {
				radial
     			frequency 4
				rotate<90,0,0>
				scale 0.03
			}
			finish{crand 0.2}
		}
		translate<paksize/4,height_water+height_base,rad>
	}
	object{
		intersection{
			object{torus{2,1}rotate<90,0,0>translate<paksize/4+rad,height_water+height_base-2,rad>}
			object{box{<0,height_water+height_base-2,0>,<paksize/2,paksize/2,paksize/2>}}
		}
		texture{waterpipe_texture}
	}
	object{
		cylinder{<paksize/4+rad+2,0,rad>,<paksize/4+rad+2,height_water+height_base-2,rad>,1}
		texture{waterpipe_texture}
	}
	object{
		intersection{
			object{torus{2,1}rotate<90,0,0>translate<paksize/4-rad,height_base-1,rad>}
			object{box{<0,height_water-1,0>,<paksize/2,paksize/2,paksize/2>}}
		}
		texture{waterpipe_texture}
	}
	object{
		cylinder{<paksize/4-rad-2,0,rad>,<paksize/4-rad-2,height_base-1,rad>,1}
		texture{waterpipe_texture}
	}
	object{pipe_obj}
}

#declare obj3=object{pipe_obj}










// ---make objects above this line---
// 
//
//
// ---put the obj---
#declare output_obj=
object{
	difference{
		object{obj
		#if(diagonal) 
		translate<-paksize/4,0,-paksize/4>
		rotate<0,-45,0>
		translate<paksize/8,0,paksize*3/8>
		#end
		}
	}
}
// ---output_area_set---
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-0.1,paksize/8,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-0.11,0+paksize/128,paksize*int_x/4>,<paksize*int_y/2+0.11,paksize*int_z,paksize*int_x/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_y,paksize*(max(int_x,int_z)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,paksize/8,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4,0+paksize/128,0-0.11>,<paksize*int_x/2+0.11,paksize*int_z,paksize*int_y/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_z,paksize*(max(int_x,int_z)+2)/2>}}
#end
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj}
	object{output_area_set_z}
	}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}
	}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}
	}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}
	}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
	translate<1,0,1>*(-paksize)
	translate<-.1,0,-.1>
}
#declare output_obj2=
object{
	difference{
		object{obj2
		#if(diagonal) 
		translate<-paksize/4,0,-paksize/4>
		rotate<0,-45,0>
		translate<paksize/8,0,paksize*3/8>
		#end
		}
	}
}
object{merge{
	object{
	intersection{object{output_obj2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj2
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj2
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj2
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
	translate<1,0,1>*0*paksize
}
#declare output_obj3=
object{
	difference{
		object{obj3
		#if(diagonal) 
		translate<-paksize/4,0,-paksize/4>
		rotate<0,-45,0>
		translate<paksize/8,0,paksize*3/8>
		#end
		}
	}
}
object{merge{
	object{
	intersection{object{output_obj3}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj3
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj3
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
	translate<1,0,1>*1*paksize
}