#include "snow.inc"
#include "temp.inc"
// ---add include files---
#include "colors.inc"
#include "new_structure.inc"


// -----------------------
// The default tile scale in this pov-ray file (not for pak file)
#local paksize=64;


// ---camera setting---
camera {
	orthographic
	location <100,81.64965809277,100>*number_hight*paksize/128
	look_at <0,0.5,0>*paksize/128
	right<1,0,-1> *paksize*number_width*2
	up<1,0,1>  *paksize*number_hight/2
	}


// ---light setting---
light_source {
	<0,173,100>
	color rgb 1
	parallel
	point_at<0,0,0>
}
// If winter==1, set a light to make the snow cover.
#if(winter)
	light_source{winter_light}
#end


// ----------------------------------
//
// the name of the object with all objects merged must be "obj"
//
// ---make objects below this line---
#declare dam_tri=
object{
	intersection{
		object{box{<sqrt(2)/2,sqrt(2)/2,.5>,<-sqrt(2)/2,-sqrt(2)/2,-.5>}rotate<0,0,45>}
		object{box{<0,0,-1>,<2,2,1>}}
	}
}
#declare dam_texture=texture{pigment{color rgb Gray50}
   normal{
     leopard 0.9
     scale .5
   }};
#declare dam_top_size=4;
#declare road=
object{
	merge{
		object{
			dam_tri
			rotate<0,-90,0>
			scale<32,dam_top_size,dam_top_size>
			translate<16,0,32-dam_top_size>
			texture{dam_texture}
		}
		object{
			dam_tri
			rotate<0,90,0>
			scale<32,dam_top_size,dam_top_size>
			translate<16,0,dam_top_size>
			texture{dam_texture}
		}
		object{
			box{<0,0,dam_top_size>,<32,16,32-dam_top_size>}
			texture{dam_texture}
		}
	}
}

#declare temp_obj_LR=
merge{
	object{
		dam_tri
		scale<64,32,32>
		translate<0,0,16>
		texture{dam_texture}
	}
	object{
		dam_tri
		rotate<0,-90,0>
		scale<64,32,32>
		translate<32+.0001,0,0.0001>
		texture{dam_texture}
	}
	object{
		dam_tri
		rotate<0,180,0>
		scale<64,32,32>
		translate<64,0,16>
		texture{dam_texture}
	}
}

#declare temp_obj=
object{
	merge{
		object{difference{
		object{
			dam_tri
			rotate<0,-90,0>
			scale<32,32,32>
			translate<16+.0001,0,-0.0001>
		}
		object{merge{object{
			box{<-2,0,0>,<2,32,32>}
			translate<8,0,0>
		}object{
			box{<-2,0,0>,<2,32,32>}
			translate<24,0,0>
		}
		}
		}
		}}
		object{
			dam_tri
			rotate<0,-90,0>
			scale<4,25,32>
			translate<8,0,0>
		}
		object{
			dam_tri
			rotate<0,-90,0>
			scale<4,25,32>
			translate<24,0,0>
		}
		object{
			box{<-2,0,0>,<2,32,0.000001>}
			translate<8,0,0>
			texture{pigment{color rgb Gray10}}
		}
		object{
			box{<-2,0,0>,<2,32,0.000001>}
			translate<24,0,0>
			texture{pigment{color rgb Gray10}}
		}
	}
	texture{dam_texture}
}


#declare temp_obj4=
object{
	merge{
		object{
			dam_tri
			rotate<0,-90,0>
			scale<32,32,32>
			translate<16+.0001,0,-0.0001>
		}
		object{
			dam_tri
			rotate<0,-90,0>
			scale<2,32,32>
			translate<16,6,0>
		}
		object{
			box{<1,0,0>,<-1,6,32>}
			translate<16,0,0>
		}
	}
	texture{dam_texture}
}

#declare obj=
object{
			dam_tri
			rotate<0,-90,0>
			scale<32,32,32>
			translate<16+.0001,0,-0.0001>
			texture{dam_texture}
}











// ---make objects above this line---
// 
//
//
// ---put the obj---
#declare output_obj=
object{
	obj
}
// ---output_area_set---
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-0.1,paksize/8,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-0.11,0+paksize/128,paksize*int_x/4>,<paksize*int_y/2+0.11,paksize*int_z,paksize*int_x/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_y,paksize*(max(int_x,int_y)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,paksize/8,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4,0+paksize/128,0-0.11>,<paksize*int_x/2+0.11,paksize*int_z,paksize*int_y/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_z,paksize*(max(int_y,int_x)+2)/2>}}
#end
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
}
