#include "snow.inc"
#include "temp.inc"
// ---add include files---
#include "colors.inc"
#include "new_structure.inc"
#include "textures.inc"


// -----------------------
// The default tile scale in this pov-ray file (not for pak file)
#local paksize=64;


// ---camera setting---
camera {
	orthographic
	location <100,81.64965809277,100>*number_hight*paksize/128*3
	look_at <0,0.5,0>*paksize/128
	right<1,0,-1> *paksize*number_width*2
	up<1,0,1>  *paksize*number_hight/2*3
	}


// ---light setting---
light_source {
	<0,173,100>
	color rgb 1
	parallel
	point_at<0,0,0>
}
// If winter==1, set a light to make the snow cover.
#if(winter)
	light_source{winter_light}
#end


// ----------------------------------
//
// the name of the object with all objects merged must be "obj"
//
// ---make objects below this line---
#declare dam_tri=
object{
	intersection{
		object{box{<sqrt(2)/2,sqrt(2)/2,.5>,<-sqrt(2)/2,-sqrt(2)/2,-.5>}rotate<0,0,45>}
		object{box{<0,0,-1>,<2,2,1>}}
	}
}
#declare dam_texture=texture{pigment{color rgb Gray50}
   normal{
     leopard 0.9
     scale .5
   }};
#declare road_texture=texture{pigment{color rgb Gray30}normal{
     bozo 2
     scale 0.3
   }}
#declare dam_top_size=6;
#declare pole_size=2;
#declare road=
object{
	merge{
		// object{
		// 	dam_tri
		// 	rotate<0,-90,0>
		// 	scale<32,dam_top_size,dam_top_size>
		// 	translate<16,0,32-dam_top_size>
		// 	texture{dam_texture}
		// }
		// object{
		// 	dam_tri
		// 	rotate<0,90,0>
		// 	scale<32,dam_top_size,dam_top_size>
		// 	translate<16,0,dam_top_size>
		// 	texture{dam_texture}
		// }
		// object{difference{
		// object{
		// 	box{<0,0,dam_top_size>,<32,19,32-dam_top_size>}
		// 	texture{dam_texture}
		// }
		// object{
		// 	box{<-1,16,dam_top_size+pole_size>,<33,20,32-dam_top_size-pole_size>}
		// 	texture{dam_texture}
		// }}}
		object{difference{
		object{
			box{<0,0,dam_top_size>,<32,19,32-dam_top_size>}
			texture{dam_texture}
		}
		object{
			box{<-1,16,dam_top_size+pole_size>,<33,20,32-dam_top_size-pole_size>}
			texture{dam_texture}
		}}}
		object{box{<0,16,dam_top_size+pole_size>,<32,16.1,32-dam_top_size-pole_size>}texture{road_texture}}
	}
}
#declare road1=
object{
	merge{
		// objec/
		// object{difference{
		// object{
		// 	box{<0,0,dam_top_size>,<32,19,32-dam_top_size>}
		// 	texture{dam_texture}
		// }
		// object{
		// 	box{<-1,16,dam_top_size+pole_size>,<33,20,32-dam_top_size-pole_size>}
		// 	texture{dam_texture}
		// }}}
		object{difference{
		object{
			box{<0,8,dam_top_size>,<32,19,32-dam_top_size>}
			texture{dam_texture}
		}
		object{
			box{<-1,16,dam_top_size+pole_size>,<33,20,32-dam_top_size-pole_size>}
			texture{dam_texture}
		}}}
		object{box{<0,16,dam_top_size+pole_size>,<32,16.1,32-dam_top_size-pole_size>}texture{road_texture}}
	}
}
#declare road2=
object{
	merge{
		object{
			dam_tri
			rotate<0,-90,0>
			scale<32,dam_top_size,dam_top_size>
			translate<16,0,32-dam_top_size>
			texture{dam_texture}
		}
		object{
			dam_tri
			rotate<0,90,0>
			scale<32,dam_top_size,dam_top_size>
			translate<16,0,dam_top_size>
			texture{dam_texture}
		}
		object{difference{
			object{
				merge{
					object{
					dam_tri
					rotate<90,0,0>
					scale<32,19,dam_top_size>
					translate<0,19/2,32-dam_top_size>
					}object{
					dam_tri
					rotate<90,0,0>
					scale<32,19,-dam_top_size>
					translate<0,19/2,dam_top_size>
					}object{
					box{<0,0,dam_top_size-.001>,<32,19,32-dam_top_size+.001>}
					}
				}
			}
			object{
				merge{
					object{
					dam_tri
					rotate<90,0,0>
					scale<32,19.1,dam_top_size>
					translate<-.01,19/2,32-dam_top_size-pole_size>
					}object{
					dam_tri
					rotate<90,0,0>
					scale<32,19.1,-dam_top_size>
					translate<-.01,19/2,dam_top_size+pole_size>
					}object{
						box{<-.01,16,dam_top_size+pole_size-.1>,<32.1,20,32-dam_top_size-pole_size+.1>}
					}
				}
			}
		}texture{dam_texture}}
		object{merge{
			object{box{<0,16,dam_top_size+pole_size>,<32,16.1,32-dam_top_size-pole_size>}}
			object{
				dam_tri
				rotate<90,0,0>
				scale<32,0.1,-dam_top_size>
				translate<-.01,16.05,dam_top_size+pole_size>
			}
			object{
				dam_tri
				rotate<90,0,0>
				scale<32,0.1,dam_top_size>
				translate<-.01,16.05,32-dam_top_size-pole_size>
			}
		}texture{road_texture}}
	}
}
#declare obj=
difference{
	object{road2}
}
#declare obj2=
difference{
	object{road2}
}

#declare obj3=
object{
	merge{
		object{road}
	}
}










// ---make objects above this line---
// 
//
//
// ---put the obj---
#declare output_obj=
object{
	difference{
		object{obj}
		object{dam_tri
		scale<32.1*2,16.1,32.1>
		translate<-.1,-.1,16>
		}
	}
}
// ---output_area_set---
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-0.1,paksize/8,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-0.11,0+paksize/128,paksize*int_x/4>,<paksize*int_y/2+0.11,paksize*int_z,paksize*int_x/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_y,paksize*(max(int_x,int_z)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,paksize/8,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4,0+paksize/128,0-0.11>,<paksize*int_x/2+0.11,paksize*int_z,paksize*int_y/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_z,paksize*(max(int_x,int_z)+2)/2>}}
#end
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
	translate<1,0,1>*(-paksize)
	// translate<-.25,0,-.25>
}
#declare output_obj2=
object{
	difference{
		object{obj2}
		object{dam_tri
		scale<32.1*1,16.1,32.1>
		translate<-.1,-.1,16>
		}
	}
}
object{merge{
	object{
	intersection{object{output_obj2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj2
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj2
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj2
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
	translate<1,0,1>*0*paksize
}
#declare output_obj3=
object{
	obj3
}
object{merge{
	object{
	intersection{object{output_obj3}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj3
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{road1
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{road1
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
	translate<1,0,1>*1*paksize
	// translate<-.5,0,-.5>
}

