#include "snow.inc"
#include "temp.inc"
// ---add include files---
#include "colors.inc"
#include "new_structure.inc"


// -----------------------
// The default tile scale in this pov-ray file (not for pak file)
#local paksize=64;


// ---camera setting---
camera {
	orthographic
	location <100,81.64965809277,100>*number_hight*paksize/128*100
	look_at <0,0.5,0>*paksize/128
	right<1,0,-1> *paksize*number_width*2
	up<1,0,1>  *paksize*number_hight/2
	}


// ---light setting---
light_source {
	<0,173,100>
	color rgb 1
	parallel
	point_at<0,0,0>
}
// If winter==1, set a light to make the snow cover.
#if(winter)
	light_source{winter_light}
#end


// ----------------------------------
//
// the name of the object with all objects merged must be "obj"
//
// ---make objects below this line---
#declare dam_tri=
object{
	intersection{
		object{box{<sqrt(2)/2,sqrt(2)/2,.5>,<-sqrt(2)/2,-sqrt(2)/2,-.5>}rotate<0,0,45>}
		object{box{<0,0,-1>,<2,2,1>}}
	}
}
#declare dam_texture=texture{pigment{color rgb Gray50}
   normal{
     leopard 0.9
     scale .5
}};

#declare power_wall_texture=texture{pigment{color Gray70}}

#declare roof_texture=texture{pigment{color SemiSweetChoc}}

#declare main_hight = 24;
#declare sub_hight = 12;

#declare dam_power_building= 
object{
	merge{
		object{
			difference{
				object{box{<12,0,6>,<52,main_hight,24>}texture{power_wall_texture}}
				object{box{<17,0,23.5>,<23,7,25>}texture{pigment{color Gray40}}}
			}
			texture{power_wall_texture}
		}
		object{
			box{<11.5,main_hight-1,5.5>,<52.5,main_hight-.001,24.5>}
			texture{roof_texture}
		}
		object{
			box{<8,0,12>,<56,sub_hight,0>}
			texture{power_wall_texture}
		}
		object{
			box{<7.5,sub_hight-1,12.5>,<56.5,sub_hight-.001,-.5>}
			texture{roof_texture}
		}
		object{
			intersection{
				box{<16,14,24>,<24,7,26>}
				difference {
					cylinder{<20,1,23>,<20,1,27>,9}
					cylinder{<20,1,22>,<20,1,28>,8.5}
				}
			}
			texture{roof_texture}
		}
		object{
			window
			scale<6,2,.001>
			translate<16,main_hight-3,6>
		}
		object{
			window
			scale<6,2,.001>
			translate<24,main_hight-3,6>
		}
		object{
			window
			scale<6,2,.001>
			translate<32,main_hight-3,6>
		}
		object{
			window
			scale<6,2,.001>
			translate<40,main_hight-3,6>
		}
		object{
			window
			scale<6,2,.001>
			translate<48,main_hight-3,6>
		}
		object{
			window
			scale<6,2,.001>
			translate<16,main_hight-3,24>
		}
		object{
			window
			scale<6,2,.001>
			translate<24,main_hight-3,24>
		}
		object{
			window
			scale<6,2,.001>
			translate<32,main_hight-3,24>
		}
		object{
			window
			scale<6,2,.001>
			translate<40,main_hight-3,24>
		}
		object{
			window
			scale<6,2,.001>
			translate<48,main_hight-3,24>
		}
	}
}

#declare water=
object{
	merge{
		object{
			difference{
				box{<0,0,0.0001>,<64,8,32>}
				box{<8,0,10>,<16,6,-1>}
				box{<24,0,10>,<16,6,.1>}
			}			
		}
		object{
			naname(<8,3,0>,<16,3,3.99>,.001,6)
		}
		object{
			naname(<16,0,0>,<16,2,3.99>,22,0.001)
		}
		object{
			naname(<16,0.1,0>,<16,2.01,3.99>,22,0.001)
			texture{pigment{
				agate
				agate_turb 0.5
				color_map{
					[0 rgbt <0,.5,1,.5>]
					[1 rgbt <.6,.9,.96,.5>]
				}
				scale .1
			}}
		}
		object{cylinder{<15.5,4,2>,<24,4,2.1>,1.8}texture{pigment{color Black}}}
	}
	texture{dam_texture}
}

#declare obj=
object{
	merge{
		object{
			water
		}
		object{
			dam_power_building
			translate<0,8,0>
		}
	}
}










// ---make objects above this line---
// 
//
//
// ---put the obj---
#declare output_obj=
object{
	obj
}
// ---output_area_set---
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-0.1,paksize/8,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-0.11,0+paksize/128,paksize*int_x/4>,<paksize*int_y/2+0.11,paksize*int_z,paksize*int_x/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_y,paksize*(max(int_x,int_y)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,paksize/8,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4,0+paksize/128,0-0.11>,<paksize*int_x/2+0.11,paksize*int_z,paksize*int_y/2+0.11>}}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_y)+2)/2+0.1,paksize*int_z,paksize*(max(int_y,int_x)+2)/2>}}
#end
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
}
