#include "snow.inc"
#include "temp.inc"
// ---add include files---
#include "colors.inc"
#include "new_structure.inc"

// -----------------------
// The default tile scale in this pov-ray file (not for pak file)
#local paksize=128;


// ---camera setting---
camera {
	orthographic
	location <100,81.64965809277,100>*number_hight*paksize/128*1000
	look_at <0,0.5,0>*paksize/128
	right<1,0,-1> *paksize*number_width*2
	up<1,0,1>  *paksize*number_hight/2*3
	}


// ---light setting---
light_source {
	<0,173,100>
	color rgb 1
	parallel
	point_at<0,0,0>
}
// If winter==1, set a light to make the snow cover.
#if(winter)
	light_source{winter_light}
#end


// ----------------------------------
//
// the name of the object with all objects merged must be "obj"
//
// ---make objects below this line---
#declare dam_tri=
object{
	intersection{
		object{box{<sqrt(2)/2,sqrt(2)/2,.5>,<-sqrt(2)/2,-sqrt(2)/2,-.5>}rotate<0,0,45>}
		object{box{<0,0,-1>,<2,2,1>}}
	}
}
#declare railbase_width=32;//width of the rail basement
#declare Ballast_Texture = texture {
    pigment {
        bozo
        color_map {
            [0.0 color rgb Gray50] 
            [0.5 color rgb Bronze] 
            [0.6 color rgb IndianRed] 
            [1.0 color rgb Sienna] 
        }
        scale 0.02 
    }
    
    normal {
        granite 0.8
        scale 0.01
    }
    
    finish {
        ambient 0.2     
        diffuse 0.7     
        specular 0.1    
        roughness 0.1   
    }
}
#declare Concrete_Texture = texture {
    pigment {
        cells // 微妙な色の濃淡でブロック感を出す
        color_map {
            [0.0 color rgb <0.60, 0.60, 0.60>]
            [1.0 color rgb <0.65, 0.65, 0.65>]
        }
        scale 0.1
    }
    normal {
        bumps 0.3
        scale 0.05
    }
    finish {
        ambient 0.2
        diffuse 0.6
        specular 0.05 // コンクリートなので光沢はほぼ無し
    }
}
#declare Grass_Texture = texture {
    pigment {
        average
        pigment_map {
            [1.0 granite
                 color_map {
                     [0.0 color rgb <0.2, 0.4, 0.1>*.5] // 深緑
                     [0.5 color rgb <0.3, 0.5, 0.1>*.8] // 標準的な草の色
                     [1.0 color rgb <0.4, 0.5, 0.2>*.5] // 少し枯れた/明るい草
                 }
            ]
        }
        scale 0.05
    }
    normal {
        // 草のわさわさした質感を出すために粗めの設定
        dents 0.02
        scale 0.03
    }
}

#declare rail_texture = texture{pigment {
	color Gray70
}}
#declare start_ring = 0;
#declare distance_ring = paksize/2;
#declare ring_radius = 10;
#declare ring_center_height =3;
#declare car_width = 9;
#declare car_height = 18;
#declare base_width = car_width;//sqrt(ring_radius*ring_radius-ring_center_height*ring_center_height);
#declare backet_width = 22;
#declare rail_distance = 7;
#declare rail_width = 1;
#declare rail_startpoint = start_ring;
#declare rail_length = -paksize/2+start_ring; 
#declare rotation_core_radius=2;
#declare rail = 
object{merge{
	object{box{<paksize/4-rail_distance/2,0,rail_startpoint+1>,<paksize/4-rail_distance/2+rail_width,-.001,rail_startpoint-rail_length+1>}texture{pigment{color Gray30}finish{emission .5}}}
	object{box{<paksize/4-rail_distance/2,-.001,rail_startpoint+1>,<paksize/4-rail_distance/2+rail_width,-rail_width,rail_startpoint-rail_length>}texture{pigment{color Brown}}}
	object{box{<paksize/4+rail_distance/2,0,rail_startpoint+1>,<paksize/4+rail_distance/2-rail_width,-0.001,rail_startpoint-rail_length+1>}texture{pigment{color Gray30}finish{emission .5}}}
	object{box{<paksize/4+rail_distance/2,-.001,rail_startpoint+1>,<paksize/4+rail_distance/2-rail_width,-rail_width-0.001,rail_startpoint-rail_length>}texture{pigment{color Brown}}}
}
translate<0,.499,0>
}
#declare rail_basement_height=6;
#declare rail_basement =
object{
	merge{
		box{<(paksize/2-rail_distance)/2-rail_width,-rail_width+0.5,rail_startpoint>,<(paksize/2-rail_distance)/2+rail_width*2,-rail_basement_height,rail_startpoint-rail_length>}
		box{<(paksize/2+rail_distance)/2+rail_width,-rail_width+0.5,rail_startpoint>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,rail_startpoint-rail_length>}
		box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,0>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,1>}
		// box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,8-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,8+1>}
		box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,16-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,16+1>}
		// box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,24-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,24+1>}
		box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,32-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,32+1>}
		// box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,40-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,40+1>}
		box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,48-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,48+1>}
		// box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,56-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,56+1>}
		box{<(paksize/2-rail_distance)/2+rail_width*2,-rail_width+0.5,64-1>,<(paksize/2+rail_distance)/2-rail_width*2,-rail_basement_height,64>}
	}
	texture{rail_texture}
}
#declare basement_texture = texture{pigment{color Gray20}normal{
      gradient x 
      normal_map {
        [0.2 marble turbulence 0.4]
        [0.4 facets coords 0.3 scale 0.3]
        [0.6 facets coords 0.3 scale 0.3]
        [0.7 marble turbulence 0.4]
       }
}}

#declare bg_box=
object{
	merge{
		object{box{<0,-0.00001,0>,<paksize/2,-paksize/4,-0.00001>}}
		object{box{<0,-0.00001,0>,<-0.00001,-paksize/4,paksize/2>}}
		object{box{<paksize/2,-0.00001,paksize/2>,<0,-paksize/4,paksize/2+0.00001>}}
		object{box{<paksize/2,-0.00001,paksize/2>,<paksize/2+0.00001,-paksize/4,0>}}
	}
	texture{bg_texture}
}
#declare elevated_height=paksize/8;
#declare obj=
merge{
	object{
		intersection {
			object{
				merge{object{
				dam_tri
				scale<-(paksize/2-railbase_width)/2,elevated_height,paksize/2>*1.001
				translate <paksize/2+.0001,0,paksize/4> // <x, y, z>
				texture{Grass_Texture}}
				object{box{<paksize/2,0,0>,<paksize,elevated_height,paksize/2>}texture{Concrete_Texture}}
				}
			}
			// object{
			// 	dam_tri
			// 	scale<(paksize/2-railbase_width)/2,elevated_height,paksize/2>*1.001
			// 	translate <-.00001,0,paksize/4> // <x, y, z>
			// 	texture{Grass_Texture}
			// }
		}
	}
}


#declare obj_diagonal=
intersection{
	object{box{<0,0,0>,<paksize/2,paksize/2,paksize/2>}texture{Concrete_Texture}}
	object{merge{
		object{obj
		translate<0,0,-paksize/2>
		scale<1/sqrt(2),1,1/sqrt(2)>
		rotate<0,45,0>
		translate<0,0,paksize/2>}
		object{obj
		scale<1/sqrt(2),1,1/sqrt(2)>
		rotate<0,45,0>
		translate<0,0,paksize/2>}
	}}
}

#declare obj_4_dir_each=
intersection{
	object{box{<-.00001,0,-.00001>,<paksize/4+.0001,paksize/2,paksize/4+.0001>}texture{Concrete_Texture}}
	object{obj_diagonal
	rotate<0,270,0>
	translate<paksize/2,0,0>}
}

#declare obj_4_dir=
union {	
	object{obj_4_dir_each}
	object{obj_4_dir_each
	rotate<0,90,0>
	translate<0,0,paksize/2>}
	object{obj_4_dir_each
	rotate<0,180,0>
	translate<paksize/2,0,paksize/2>}
	object{obj_4_dir_each
	rotate<0,-90,0>
	translate<paksize/2,0,0>}
}

#declare obj_curve=
// union {
intersection{ 
	object{obj}
	object{
		obj
		rotate<0,90,0>
		translate <0+.0000001, 0, paksize/2+.000001> // <x, y, z>
	}
	object{box{<0+.00001,0,0+.00001>,<paksize/2-.00001,paksize/2,paksize/2-.00001>}texture{Concrete_Texture}}
}





#declare slope1=atan2(1,4);
#declare obj_slope1=
intersection {
	object{obj
	scale<1,cos(slope1),1/cos(slope1)*1.2>
	rotate<-slope1/pi*180,0,0>
	}	
	// object{obj}	
	object{box{<0+.00001,0,0+.00001>,<paksize/2-.00001,paksize/2,paksize/2-.00001>}texture{Concrete_Texture}}
}

#declare slope2=atan2(1,2);
#declare obj_slope2=
intersection{
	object{obj
	scale<1,cos(slope2),1/cos(slope2)*1.2>
	rotate<-slope2/pi*180,0,0>
	}	
	// object{obj}	
	object{box{<0+.00001,0,0+.00001>,<paksize/2-.00001,paksize/2,paksize/2-.00001>}texture{Concrete_Texture}}
}





// ---make objects above this line---
// 
//
//
// ---put the obj---
#declare output_obj=
merge{
// object{difference {
object{intersection {
	// object{obj_3_dir}
	object{box{<-.000001,-.000001,-.000001>,<paksize/2+.000001,paksize/8,paksize/2+.0000001>}texture{Concrete_Texture}}
	// object{difference{
	// object{
	// box{<-paksize/2,paksize/4,paksize/4>*1.414,<paksize/2+1,-paksize/4,-paksize/4>*1.414}
	// rotate<45,0,0>
	// scale<1,.5,1>*.95
	// }
	// object{
	// 	box{<paksize/4,-1,paksize/4>*1.414,<-paksize/4,paksize,-paksize/4>*1.414}
	// 	rotate<0,45,0>
	// 	scale<1,1,.5/1.414>
	// 	translate<paksize/4,0,paksize/2>
	// }
	// }}
	//object{box{<0,-32,0>,<32,64,32>}texture{bg_texture}}
}}
// object{
// 	rail
// 	translate<0,.249,0>
// }
}

#declare output_obj_end =
object{obj_slope2}
#declare output_obj_front=
object{obj_slope1}
// ---output_area_set---
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-0.1,paksize/8,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-0.11,0+paksize/128,paksize*int_x/4>,<paksize*int_y/2+0.11,paksize*int_z,paksize*int_x/2+0.11>}}texture{bg_texture}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_y,paksize*(max(int_x,int_z)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,paksize/8,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4,0+paksize/128,0-0.11>,<paksize*int_x/2+0.11,paksize*int_z,paksize*int_y/2+0.11>}}texture{bg_texture}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_z,paksize*(max(int_x,int_z)+2)/2>}}
#end
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj_end}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj_end
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{merge{object{output_obj_end}
		}
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{merge{object{output_obj_end}
		}
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
}
// #declare make_front_image=1;
#declare output_area_set_x=
#if(make_front_image)
object{merge{box{<0-0.1,paksize/8,0-0.1>,<paksize*int_y/2+0.1,paksize*int_z,paksize*int_x/2+0.1>}box{<0-0.11,0+paksize/128,paksize*int_x/4>,<paksize*int_y/2+0.11,paksize*int_z,paksize*int_x/2+0.11>}}texture{bg_texture}}
#else
object{box{<-paksize,-paksize*int_y,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_y,paksize*(max(int_x,int_z)+2)/2>}}
#end
#declare output_area_set_z=
#if(make_front_image)
object{merge{box{<-paksize,paksize/8,-paksize>,<paksize*(int_x+2)/2+0.1,paksize*int_z,paksize*(int_y+2)/2+0.1>}box{<paksize*int_x/4,0+paksize/128,0-0.11>,<paksize*int_x/2+0.11,paksize*int_z,paksize*int_y/2+0.11>}}texture{bg_texture}}
#else
object{box{<-paksize,-paksize*int_z,-paksize>,<paksize*(max(int_x,int_z)+2)/2+0.1,paksize*int_z,paksize*(max(int_x,int_z)+2)/2>}}
#end
object{merge{
	object{
	intersection{object{output_obj_front}
	// object{output_area_set_z}
	}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj_front
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	// object{output_area_set_x}
	}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj_front
		rotate<0,180,0>
		translate<0,0,1>*paksize*int_y/2
		translate<1,0,0>*paksize*int_x/2}
	// object{output_area_set_z}
	}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj_front
		rotate<0,270,0>
		translate<1,0,0>*paksize*int_y/2}
	// object{output_area_set_x}
	}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}}
	translate<-1,0,-1>*paksize
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
}
// Place objects in 4 directions
object{merge{
	object{
	intersection{object{output_obj}
	object{output_area_set_z}}
		translate<-1,0,1>*paksize*number_width*3/4
	}
	object{
	intersection{object{output_obj
		rotate<0,90,0>
		translate<0,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*1/4
	}
	object{
	intersection{object{output_obj
		rotate<0,180,0>
		translate<1,0,1>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-1)/4
	}
	object{
	intersection{object{output_obj
		rotate<0,-90,0>
		translate<1,0,0>*paksize*int_x/2}
	object{output_area_set_x}}
		translate<-1,0,1>*paksize*number_width*(-3)/4
	}
	}
	translate<-1,0,-1>*paksize*(-1)
	scale<1,.8165,1> // To set 1 distance of y direction as 1px, rescaling the hight
}
